
iset = [107:222]; % default is 107:222
gset = [5:10]; % default is 5:10

a(5:10,1:2)=[215 0;100 300;100 100;0 215;300 100;100 100];
b(5:10,1:2)=[815 650;500 900;500 900;650 815;900 500;900 500];
p(5:10,1:2)=[1.4 0.9;0.7 1.3;0.5 1.3;0.9 1.4;1.3 0.7;1.3 0.5];

levelplay(5:10,1:4) = [455 648.9 573.3 815;420 273 382.2 210;250 195 162.5 100;463.5 409.5 584.01 650;390 546 354.9 300;390 325 253.5 130];
oplevelplay(5:10,1:4) = levelplay([8 9 10 5 6 7],1:4);


lamgrid = [0.01 0.05:0.05:1 1.5:0.5:10 15:5:250 300:50:1000];
upperlamgrid = [1500:500:10000];
%lamgrid = [133]; %fixing lambda at the average (1.325529) for CGC06

epsgrid = [0:18]./18;

for g=gset
    nstratsi(g) = b(g,1)-a(g,1)+1;
    nstratsj(g) = b(g,2)-a(g,2)+1;
end

exacthit = zeros(max(iset),4,max(gset));
obslike = NaN*zeros(max(iset),length(lamgrid),length(epsgrid),4,max(gset));
clear bestlams bestepss bestks;

lzerologlikevalue(gset) = log(1./(b(gset,1)-a(gset,1)+1));

for i=iset
    clear logitmix likelihoodbyg loglikelihood;
    likelihoodbyg = NaN*zeros(length(lamgrid),length(epsgrid),4,4);
    loglikelihood = NaN*zeros(length(lamgrid),length(epsgrid),4);
    for k=1:4
        for g=gset
            if guess(i,g)>levelplay(g,k)-0.5 & guess(i,g)<=levelplay(g,k)+0.5
                % first do the exact hits
                exacthit(i,k,g)=1;
                likelihoodbyg(:,:,k,g) = repmat(epsgrid,length(lamgrid),1);
            else
                if k==1
                	mix = ones(1,nstratsj(g))./nstratsj(g);
                elseif k==4
                    mix = zeros(1,nstratsj(g));
                    mix( round(oplevelplay(g,k))-a(g,2)+1 )=1;
                else
                    mix = zeros(1,nstratsj(g));
                    mix( round(oplevelplay(g,k-1))-a(g,2)+1 )=1;
                end
                logitmix = logbr(a(g,1),b(g,1),a(g,2),b(g,2),p(g,1),mix,lamgrid);
                likelihoodbyg(:,:,k,g) = logitmix(:,round(guess(i,g))-a(g,1)+1) * (1-epsgrid);
            end
        end
        loglikelihood(:,:,k) = sum(sq(log(likelihoodbyg(:,:,k,gset))),3);
    end
    
    %Estimation game-by-game
    for g=gset
        [bestlamidxsbyg{i,g} bestepsidxsbyg{i,g} bestksbyg{i,g}] = ind2sub(size(likelihoodbyg),find(likelihoodbyg(:,:,:,g)==max(max(max(likelihoodbyg(:,:,:,g))))));
        maxloglikevaluebyg(i,g) = log(max(max(max(likelihoodbyg(:,:,:,g)))));
        bestlamsbyg{i,g} = lamgrid(bestlamidxsbyg{i,g});
        bestepssbyg{i,g} = epsgrid(bestepsidxsbyg{i,g});
        if bestepssbyg{i,g}==[1]
            bestlamsbyg{i,g}=[];
        end
        bestksuncensoredbyg{i,g} = bestksbyg{i,g};
        bestlamsuncensoredbyg{i,g} = bestlamsbyg{i,g};
        bestepssuncensoredbyg{i,g} = bestepssbyg{i,g};
        if maxloglikevaluebyg(i,g) < lzerologlikevalue(g)
            bestksbyg{i,g} = [0];
            maxloglikevaluebyg(i,g) = lzerologlikevalue(g);
            bestlamsbyg{i,g} = [0];
            bestepssbyg{i,g} = [0];
        end
        mlelevelbyg(i,g) = unique(bestksbyg{i,g});
    end
    
    %Pooled estimation for all GGs
    [bestlamidxs{i} bestepsidxs{i} bestks{i}] = ind2sub(size(loglikelihood),find(loglikelihood==max(max(max(loglikelihood)))));
    maxloglikevalue(i) = max(max(max(loglikelihood)));
    bestlams{i} = lamgrid(bestlamidxs{i});
    bestepss{i} = epsgrid(bestepsidxs{i});
    if bestepss{i}==[1]
        bestlams{i}=[];
    end
    bestksuncensored{i} = bestks{i};
    bestlamsuncensored{i} = bestlams{i};
    bestepssuncensored{i} = bestepss{i};
    if maxloglikevalue(i) < sum(lzerologlikevalue(gset))
        bestks{i} = [0];
        maxloglikevalue(i) = sum(lzerologlikevalue(gset));
        bestlams{i} = [0];
        bestepss{i} = [0];
    end
    mlelevelbyclass(i,2) = unique(bestks{i});
    
    % Display
    if bestks{i}(1)>0
        disp(['Player=' mat2str(i) ' Guesses=' mat2str(guess(i,gset)) ' Levels=' mat2str([mlelevelbyg(i,gset) mlelevelbyclass(i,2)]) ' LevelPlays=' mat2str(levelplay(gset,bestks{i}(1))) ' Epsilon=' mat2str(unique(bestepss{i})) ' Lambda=' mat2str(bestlams{i}) ]);
    else
        disp(['Player=' mat2str(i) ' Guesses=' mat2str(guess(i,gset)) ' Level=' mat2str(unique(bestks{i})) ' LevelPlays=RANDOM Epsilon=' mat2str(unique(bestepss{i})) ' Lambda=' mat2str(bestlams{i}) ]);
    end
end

%hist(mlelevelbyclass(iset,2));