% This file replicates the main results of GHW2015

% This loads alldata.csv
loaddata;

% We need to put their guesses into a single matrix
for i=1:222
    guess(i,:) = [g1ra(i) g2ra(i) g3ra(i) g4ra(i) g5ra(i) g6ra(i) g7ra(i) g8ra(i) g9ra(i) g10ra(i)];
    guesshi(i,:) = [g1hi(i) g2hi(i) g3hi(i) g4hi(i) g5hi(i) g6hi(i) g7hi(i) g8hi(i) g9hi(i) g10hi(i)];
    guesslo(i,:) = [g1lo(i) g2lo(i) g3lo(i) g4lo(i) g5lo(i) g6lo(i) g7lo(i) g8lo(i) g9lo(i) g10lo(i)];
end
% And we need to store the UG payoffs
ugpays{1}=[1 10 0 0 0 0 -11;
   -10 0 10 0 0 0 0;
    0 -10 0 10 0 0 0;
    0 0 -10 0 10 10 10;
    0 0 0 -10 0 0 0;
    0 0 0 -10 0 0 0;
    0 0 0 -10 0 0 -11;
   ];

ugpays{2}=...
   [1 10 0 0 0 0 0 0 -11;
   -10 0 10 0 0 0 0 0 0;
    0 -10 0 10 0 0 0 0 0;
    0 0 -10 0 10 10 10 10 10;
    0 0 0 -10 0 0 0 0 0;
    0 0 0 -10 0 0 0 0 0;
    0 0 0 -10 0 0 0 0 0;
    0 0 0 -10 0 0 0 0 0;
    0 0 0 -10 0 0 0 0 -11;
   ];
ugpays{3}=...
   [1 10 0 0 0 0 0 0 -11;
   -10 0 10 0 0 0 0 0 0;
    0 -10 0 10 0 0 0 0 0;
    0 0 -10 0 10 0 0 0 0;
    0 0 0 -10 0 10 0 0 0;
    0 0 0 0 -10 0 10 10 10;
    0 0 0 0 0 -10 0 0 0;
    0 0 0 0 0 -10 0 0 0;
    0 0 0 0 0 -10 0 0 -11;
   ];
ugpays{4}=[1 10 0 0 0 0 -11;
   -10 0 10 0 0 0 0;
    0 -10 0 10 0 0 0;
    0 0 -10 0 30 10 10;
    0 0 0 -30 0 0 0;
    0 0 0 -10 0 0 0;
    0 0 0 -10 0 0 -11;
   ];

% Now we analyze the data

% These scripts generate the levels
makelevelsmleug;
makelevelsmleallug;
makelevelsmleeachgg;

% Now create the frequencies of levels by game and class (Table 2)
for g=1:10
    temp = crosstabint(mlelevelbyg(iset,g),zeros(length(iset),1),0,0,4);
    levelfreqbyg{g} = temp(:,1)'./length(iset);
    levelfreqbyg{g} % this just outputs it to the screen
end
for g=1:2
    temp = crosstabint(mlelevelbyclass(iset,g),zeros(length(iset),1),0,0,4);
    levelfreqbyclass{g} = temp(:,1)'./length(iset);
    levelfreqbyclass{g} % output to screen
end

% Now we generate the Markov transition matrices (Tables 3--5)
gset=[1:4];
makemarkov;
markovmatrixug = markovmatrix
gset=[5:10];
makemarkov;
makrovmatrixgg = markovmatrix
makemarkov_btwnclasses;

% Now we look at switch frquencies (Table 6)
% UG vs GG
makeswitchfreq_byclass;
% UG vs UG
garange = [1:4];
gbrange = [1:4];
makeswitchfreq;
% GG vs GG
garange = [5:10];
gbrange = [5:10];
makeswitchfreq;

