% inputs: guess(i,g) ugpays{g}
% functions: logbrug
iset = [107:222]; % default is 107:122
gset = [1:4]; % default is 1:4


lamgrid = [0.01 0.05:0.05:1 1.5:0.5:10 15:5:250 250:50:1000];
upperlamgrid = [1000:500:10000];
%lamgrid = [133]; %fixing lambda at the average (1.325529) for CGC06

epsgrid = [0:5 10:5:90 95:100]./100;

nstrats = [7 9 9 7];
levelplay(1:4,1:4) = [4 3 2 1;4 3 2 1;6 5 4 1;4 3 2 1];
oplevelplay(1:4,1:4) = levelplay(1:4,1:4);
levelblf(1:4,1:4) = [0 4 3 1;0 4 3 1;0 6 5 1;0 4 3 1];


exacthit = zeros(length(iset),4,length(gset));
obslike = NaN*zeros(length(iset),length(lamgrid),length(epsgrid),4,length(gset));
clear bestlams bestepss bestks;

lzerologlikevalue = sum( log(1./nstrats(gset)) );

for i=iset
    clear logitmix likelihoodbyg loglikelihood;
    likelihoodbyg = NaN*zeros(length(lamgrid),length(epsgrid),4,4);
    loglikelihood = NaN*zeros(length(lamgrid),length(epsgrid),4);
    for k=1:4
        for g=gset
            if guess(i,g) == levelplay(g,k)
                % first do the exact hits
                exacthit(i,k,g)=1;
                likelihoodbyg(:,:,k,g) = repmat(epsgrid,length(lamgrid),1);
            else
                mix = zeros(1,nstrats(g));
                if k==1
                	mix = ones(1,nstrats(g));
                    mix = mix./sum(mix);
                else
                    mix(levelblf(g,k))=1;
                end
                for lamidx=1:length(lamgrid)
                    for epsidx = 1:length(epsgrid)
                        logitmix = logbrug(ugpays{g},mix,lamgrid(lamidx)/100)';
                        likelihoodbyg(lamidx,epsidx,k,g) = (1-epsgrid(epsidx)).*logitmix(guess(i,g));
                    end
                end
            end
        end
        loglikelihood(:,:,k) = sum(sq(log(likelihoodbyg(:,:,k,:))),3);
    end
    [bestlamidxs{i} bestepsidxs{i} bestks{i}] = ind2sub(size(loglikelihood),find(loglikelihood==max(max(max(loglikelihood)))));
    maxloglikevalue(i) = max(max(max(loglikelihood)));
    bestlams{i} = lamgrid(bestlamidxs{i});
    bestepss{i} = epsgrid(bestepsidxs{i});
    if bestepss{i}==[1]
        bestlams{i}=[];
    end
    bestksuncensored{i} = bestks{i};
    bestlamsuncensored{i} = bestlams{i};
    bestepssuncensored{i} = bestepss{i};
    if maxloglikevalue(i) < lzerologlikevalue
        bestks{i} = [0];
        maxloglikevalue(i) = lzerologlikevalue;
        bestlams{i} = [0];
        bestepss{i} = [0];
    end
    disp(['Player=' mat2str(i) ' Guesses=' mat2str(guess(i,1:4)) ' Level=' mat2str(unique(bestks{i})) ' Epsilon=' mat2str(unique(bestepss{i})) ' Lambda=' mat2str(bestlams{i}) ]);
    mlelevelbyclass(i,1) = unique(bestks{i});
end

%hist(mlelevelbyclass(iset,1))

for i=iset
    if isempty(bestlams{i})
        bestlamsvec(i)=NaN;
    else
        bestlamsvec(i)=unique(bestlams{i});
    end
end
[spearcorrlam,pval] = corr(mlelevelbyclass(logical([zeros(1,min(iset)-1) ones(1,length(iset))]) & mlelevelbyclass(:,1)'>1,1),bestlamsvec(logical([zeros(1,min(iset)-1) ones(1,length(iset))]) & mlelevelbyclass(:,1)'>1)','type','Spearman')

for i=iset
    if isempty(bestepss{i})
        bestepssvec(i)=NaN;
    else
        bestepssvec(i)=unique(bestepss{i});
    end
end
[spearcorreps,pval] = corr(mlelevelbyclass(logical([zeros(1,min(iset)-1) ones(1,length(iset))]) & mlelevelbyclass(:,1)'>1,1),bestepssvec(logical([zeros(1,min(iset)-1) ones(1,length(iset))]) & mlelevelbyclass(:,1)'>1)','type','Spearman')


